/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

void main(void)
{
	vec2 p = gl_FragCoord.xy / iResolution.xy;
    vec2 q = -1.0 + 2.0*p;
    q.x *= iResolution.x/iResolution.y;
    
    q.x /= 1.0*sin(0.250*iGlobalTime);
    
    float r = sqrt(dot(q,q));
    
    r += 0.45*sin(2.0*iGlobalTime);
    
    vec3 col = vec3(p,0.5+0.5*sin(iGlobalTime));
    
    float t = 0.0;
    
    t += 200.0*cos(sin(iGlobalTime/2.0));
    
    if(r<0.8){
    	//col *= 0.5 + sqrt(sin(t*q.y*q.x*20.0));
        
        col *= 1.0 - 0.5*smoothstep(0.6,0.9,r);
        
        if(r<0.3){
            col /= vec3(0.5,0.75,0.5);
            col *= 1.0 - smoothstep(0.1,0.4,r);
        }
        
    }
    else
        col *= 0.25 + sqrt(sin(t*q.y*q.x));
    
	gl_FragColor = vec4(col,1.0);
}